package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.dto.GroupDto;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.dto.Result;
import com.edgec.browserbackend.common.utils.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/3/11 7:52 下午
 **/
@RestController
@RequestMapping("/config")
public class ConfigController {

    @Autowired
    private IpResourceService ipResourceService;

    @RequestMapping(value = "/ipOptions", method = RequestMethod.POST)
    public ResultDto getIpOptions() {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.getIpOptions());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/setipOptions", method = RequestMethod.POST)
    public ResultDto setIpOptions() {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.setIpOptions();
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/platformOptions", method = RequestMethod.POST)
    public ResultDto getPlatformOptions() {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.getPlatformOptions());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }
}
