package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.Group;
import com.edgec.browserbackend.browser.dto.GroupDto;
import com.edgec.browserbackend.browser.service.GroupService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/group")
public class GroupController {

    @Autowired
    private GroupService groupService;

    @RequestMapping("/add")
    public ResultDto addGroup(Principal principal, @RequestBody GroupDto groupDto) {
        ResultDto resultDto = new ResultDto();
        try {
            GroupDto groupDto1 = new GroupDto();
            groupDto1.setId(groupService.addGroup(principal.getName(), groupDto.getName()));
            resultDto.setData(groupDto1);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping("/update")
    public ResultDto updateGroup(Principal principal, @RequestBody Group group) {
        ResultDto resultDto = new ResultDto();
        try {
            groupService.updateGroup(principal.getName(), group);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping("/del")
    public ResultDto deleteGroup(Principal principal, @RequestBody GroupDto groupDto) {
        ResultDto resultDto = new ResultDto();
        try {
            groupService.deleteGroup(principal.getName(), groupDto.getId());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping("/list")
    public ResultDto getGroupList(Principal principal) {
        ResultDto resultDto = new ResultDto();
        try {
            List<GroupDto> groupDtos = groupService.getGroupList(principal.getName());
            resultDto.setData(groupDtos);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

}
