package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.account.repository.FileRepository;
import com.edgec.browserbackend.account.repository.FileRepositoryImpl;
import com.edgec.browserbackend.browser.domain.ProxyConfig;
import com.edgec.browserbackend.browser.domain.UserShop;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import java.io.File;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class ProxyConfigRepositoryCustomImpl implements ProxyConfigRepositoryCustom {

    @Autowired
    private FileRepositoryImpl fileRepository;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean updateProxy(File file, long time) {
        String fileId = fileRepository.updateFile(file, "3proxy");
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        Update update = new Update();
        update.set("configFileId", fileId).set("timestamp", time);
        UpdateResult operation = mongoTemplate.upsert(basicQuery, update, ProxyConfig.class);
        if (operation.getModifiedCount() < 1)
            return false;
        else
            return true;

    }
}
