package com.edgec.browserbackend.common.commons.error;

import com.edgec.browserbackend.common.commons.core.ApplicationContextProvider;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

import java.time.LocalDateTime;
import java.util.Locale;

public class ApiError {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy hh:mm:ss")
    private LocalDateTime timestamp;
    private String message;
    private String debugMessage;
    private ErrorCode errorCode;

    private Object[] args;

    public ApiError(ErrorCode code, Object... args) {
        timestamp = LocalDateTime.now();
        this.errorCode = code;
        this.args = args;

    }

    public ApiError(ErrorCode errorCode, String message, Object... args) {
        this(errorCode);
        this.message = message;
        this.args = args;
    }

    public ApiError(ErrorCode errorCode, Throwable ex, Object... args) {
        this(errorCode);
        this.message = ex.getMessage();
        this.debugMessage = ex.getLocalizedMessage();
        this.args = args;
    }

    public ApiError(String message,ErrorCode errorCode, Throwable ex, Object... args) {
        this(errorCode);
        this.message = message;
        this.debugMessage = ex.getLocalizedMessage();
        this.args = args;
    }


    public String getMessage() {

        MessageSource messageSource = ApplicationContextProvider.getBean(MessageSource.class);
        Locale locale = LocaleContextHolder.getLocale();

        try{
            return messageSource.getMessage(errorCode.toString(), args, locale);
        } catch(NoSuchMessageException e) {
            return this.message;
        }
    }

    public String getDebugMessage() {
        return debugMessage;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }
}
