package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.RealnameAuthRecord;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;


public class RealnameAuthRecordRepositoryCustomImpl implements RealnameAuthRecordRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public void updateIsUsed(String shortUrl, long time, boolean success) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(shortUrl));

        Update update = new Update();
        update.set("authTime", time).set("isSuccess", success);
        mongoTemplate.upsert(basicQuery, update, RealnameAuthRecord.class);
    }

}
