package com.edgec.browserbackend.account.controller;

import com.edgec.browserbackend.account.service.PaymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 回调接口
 *
 * @Author: Chen
 * @Date: 2024/09/20
 */
@RestController
@RequestMapping("/payCallBack")
public class PayCallBackController {

    @Autowired
    private PaymentService paymentService;

    /**
     * 使用微信进行账户充值成功后，微信会调用该接口
     */
    @RequestMapping(path = "/wx/{tradno}")
    public String wechatPayCallback(@PathVariable String tradno) {
        return paymentService.wechatPayCallback(tradno);
    }

    @RequestMapping(path = "/ali/{tradno}")
    public void alipayPayCallback(@PathVariable String tradno) {
        paymentService.alipaCallback(tradno);
    }

}
