package com.edgec.browserbackend.account.domain;

import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/2/11 5:20 下午
 **/
@Document(collection = "clouduserorder")
@JsonIgnoreProperties(ignoreUnknown = true)
public class CloudUserOrder {
    @Id
    private String id;
    private String tradeNo = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())+ SmsUtils.createRandom(true, 4);
    private String username;
    private String orderTimeStamp;
    private Services service;
    //0 -- newip, 1 --renew, 2 --ipkeptfee, 3 --deleteip, 4 -- stopinstanceonly , 5 -- bindinstance, 6 -- refundipkeptfee
    //7 -- newcvm , 8 -- renewcvm , 9 -- intelligroup, 10 -- resetcvm, 11 -- modifycvmspec
    private int chargeType;
    private OrderStatus status;
    private float rate;
    private HashMap<String, String> details;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOrderTimeStamp() {
        return orderTimeStamp;
    }

    public void setOrderTimeStamp(String orderTimeStamp) {
        this.orderTimeStamp = orderTimeStamp;
    }

    public Services getService() {
        return service;
    }

    public void setService(Services service) {
        this.service = service;
    }

    public int getChargeType() {
        return chargeType;
    }

    public void setChargeType(int chargeType) {
        this.chargeType = chargeType;
    }

    public float getRate() {
        return rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public OrderStatus getStatus() {
        return status;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public HashMap<String, String> getDetails() {
        return details;
    }

    public void setDetails(HashMap<String, String> details) {
        this.details = details;
    }

    public enum OrderStatus {
        UNPAID,
        PAYING,
        PAID,
        FAILURE,
        EXPIRED;
    }


}
