package com.edgec.browserbackend.account.service.impl;

import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.service.EmailService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;

import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@Service
public class EmailServiceImpl implements EmailService {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    private JavaMailSender mailSender;

    @Autowired
    private TemplateEngine templateEngine;

    @Override
    public void sendResetPassword(String name, String email, String code) {
        Context context = new Context();
        context.setVariable("id", name);
        context.setVariable("code", code);
        context.setVariable("time", ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss")));
        String emailContent = templateEngine.process("reset", context);
        sendHtmlMail(email,"Cloudam云端软件 | 密码重置",emailContent);
    }

    public void sendEmailVerification(String username, String email, String code) {
        Context context = new Context();
        context.setVariable("id", username);
        context.setVariable("code", code);
        context.setVariable("time", ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss")));
        String emailContent = templateEngine.process("verification", context);
        sendHtmlMail(email,"Cloudam云端软件 | 注册邮箱验证",emailContent);
    }

    public void sendHtmlMail(String to, String subject, String content) {
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            InternetAddress from = new InternetAddress("notify@bkunyun.com", "Cloudam云端软件");
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            mailSender.send(message);
            log.debug("HTML email sent successfully");
        } catch (Exception e) {
            log.error("HTML email sent error", e);
            throw new ClientRequestException(AccountErrorCode.EMAILSENTERROR, "Failed to send email, please check your email address");
        }
    }
}
