package com.edgec.browserbackend.account.service.impl;

import com.edgec.browserbackend.account.service.UserLackMoneyService;
import com.edgec.browserbackend.account.service.UserPrePaidBillingService;
import com.edgec.browserbackend.account.domain.BillStatus;
import com.edgec.browserbackend.account.domain.DeductionRecord;
import com.edgec.browserbackend.account.domain.UserBalance;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import com.edgec.browserbackend.account.repository.UserBalanceRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import com.edgec.browserbackend.account.utils.AccountServicePool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Service
public class UserPrePaidBillingServiceImpl implements UserPrePaidBillingService {

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @Autowired
    private UserBalanceRepository balanceRepository;

    @Autowired
    private UserLackMoneyService updateLackMoney;

    @Override
    public void updateUserBillingAndBalance(List<UserPrePaidBilling> billings, boolean ifMessageRemind) {
        CompletableFuture.runAsync(() -> {
            UserBalance balance = balanceRepository.findById(billings.get(0).getUsername()).orElse(null);
            Iterator<UserPrePaidBilling> userBillings = billings.iterator();
            while (userBillings.hasNext()) {
                UserPrePaidBilling billing = userBillings.next();
                float shouldPayAmount;
                if (billing.getDeductionRecords() == null) {
                    shouldPayAmount = billing.getTotal();
                } else {
                    List<DeductionRecord> deductionAmount = billing.getDeductionRecords();
                    shouldPayAmount = billing.getTotal() - ((Double) deductionAmount.stream().mapToDouble(DeductionRecord::getDeductionAmount).sum()).floatValue();
                }

                if (balance == null || balance.getBalanced() < 1) {
                    break;
                } else {
                    DeductionRecord deductionRecord = new DeductionRecord();
                    deductionRecord.setDeductionTime(Instant.now().getEpochSecond());
                    billing.addDeductionRecord(deductionRecord);
                    if (balance.getBalanced() < shouldPayAmount) {
                        float affordable = balance.getBalanced();
                        deductionRecord.setDeductionAmount(affordable);
                        if (userPrePaidBillingRepository.updateBillStatus(billing.getId(), BillStatus.UNPAID, BillStatus.UNPAID, billing.getDeductionRecords()) == 1) {
                            balanceRepository.incrementBalance(balance, -affordable, affordable);
                        }
                        break;
                    } else {
                        deductionRecord.setDeductionAmount(shouldPayAmount);
                        if (userPrePaidBillingRepository.updateBillStatus(billing.getId(), BillStatus.UNPAID, BillStatus.PAID, billing.getDeductionRecords()) == 1) {
                            balanceRepository.incrementBalance(balance, -shouldPayAmount, shouldPayAmount);
                            billing.setStatus(BillStatus.PAID);
                            balance.setBalanced(balance.getBalanced() - shouldPayAmount);
                        }
                    }
                }
            }
            updateLackMoney.updateLackMoney(billings, ifMessageRemind);
        }, AccountServicePool.taskPool);
    }

    @Override
    public void refreshUserBillingStatus(String username) {
        updateUserBillingAndBalance(userPrePaidBillingRepository.findByUsernameAndStatus(username, BillStatus.UNPAID), false);
    }

    @Override
    public List<UserPrePaidBilling> findUserBillingByUnpaid(String username, BillStatus billStatus) {
        return userPrePaidBillingRepository.findByUsernameAndStatus(username, BillStatus.UNPAID);
    }
}
