package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.OperationHistory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

public interface OperationHistoryRepository extends MongoRepository<OperationHistory, String> {
    OperationHistory findFirstByUsername(String username);

    Page<OperationHistory> findByAdministratorAndOperationTimeGreaterThanOrderByOperationTimeDesc(String administrator, long time, Pageable pageable);
    Page<OperationHistory> findByUsernameAndOperationTimeGreaterThanOrderByOperationTimeDesc(String username, long time, Pageable pageable);

    int countByUsername(String username);
}
