package com.edgec.browserbackend.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.thymeleaf.expression.Lists;

/**
 * @Description //地区映射枚举
 * @Date 2023/11/21 10:49
 * @Author Chen
 **/
@AllArgsConstructor
@Getter
public enum RegionMappingEnum {

    MAIN_LAND("mainland","中国随机","",""),
    CN_HZ("hangzhou","杭州","cn-hangzhou",""),
    CN_SH("shanghai","上海","cn-shanghai","ap-shanghai"),
    CN_SZ("shenzhen","深圳","cn-shenzhen",""),
    CN_GZ("guangzhou","广州","cn-guangzhou","ap-guangzhou"),
    CN_BJ("beijing","北京","cn-beijing","ap-beijing"),
    CN_QD("qingdao","青岛","cn-qingdao",""),
    CN_ZJK("zhangjiakou","张家口","cn-zhangjiakou",""),
    CN_HHHT("huhehaote","呼和浩特","cn-huhehaote",""),
    CN_CD("chengdu","成都","cn-chengdu",""),
    CN_HY("heyuan","河源","cn-heyuan",""),
    CN_HK("hongkong","中国香港","cn-hongkong",""),
    US("us","美国随机","",""),
    US_CALIFORNIA("california","加利福尼亚","",""),//待确认
    US_VIRGINIA("virginia","弗吉尼亚","us-east-1",""),
    EU_UK("uk","英国-伦敦","eu-west-1",""),
    EU_CENTRAL("germany","德国-法兰克福","eu-central-1","eu-frankfurt"),
    JAPAN("japan","日本-东京","ap-northeast-1","ap-tokyo"),
    SINGAPORE("singapore","新加坡","ap-southeast-1","ap-singapore"),
    AUSTRALIA("australia","澳大利亚-悉尼","",""),//待确认
    MALAYSIA("malaysia","马来西亚-吉隆坡","ap-southeast-3",""),
    YAJIADA("yajiada","印度尼西亚-雅加达","ap-southeast-5","ap-jakarta"),
    INDIA("india","孟买","","ap-mumbai"),//待确认
    MEAST("meast","迪拜","me-east-1",""),
    BRAZIL("brazil","巴西-圣保罗","","sa-saopaulo"),
    ULANNQAB("ulanqab","乌兰察布","cn-wulanchabu",""),
    SILICON("silicon","美国（硅谷）","us-west-1","na-siliconvalley"),

    NANJING("nanjing","南京","","ap-nanjing"),
    BANGKOK("bangkok","泰国（曼谷）","ap-southeast-7",""),
    MANILA("manila","菲律宾-马尼拉","ap-southeast-6",""),
    SEOUL("seoul","韩国-首尔","ap-northeast-2","ap-seoul"),

    ;


    private final String region;//地区

    private final String regionCn;//地区中文

    private final String aliRegionApi;//阿里云地区api

    private final String tenCentRegionApi;//腾讯云地区api


    public static RegionMappingEnum getByRegion(String type) {
        return Arrays.stream(RegionMappingEnum.values())
            .filter(item -> Objects.equals(item.getRegion(), type))
            .findFirst().orElse(null);
    }

    public static RegionMappingEnum getUsRandom(){
        Random random = new Random();
        int randomNumber = random.nextInt(2);
        if(randomNumber == 0){
            return RegionMappingEnum.US_CALIFORNIA;
        }else {
            return RegionMappingEnum.US_VIRGINIA;
        }
    }

    public static RegionMappingEnum getCnRandom(){
        Random random = new Random();
        int randomNumber = random.nextInt(3);
        if(randomNumber == 0){
            return RegionMappingEnum.CN_BJ;
        }else if(randomNumber == 1){
            return RegionMappingEnum.CN_HZ;
        }else {
            return RegionMappingEnum.CN_SZ;
        }
    }

    /**
     * @author Chen
     * @description 获取阿里云映射 region
     * @date 2024/7/30 21:40
     */
    public static String getAliRegion(String region) {
        String aliResion = "";
        RegionMappingEnum byRegion = getByRegion(region);
        if(Objects.isNull(byRegion)){
            return aliResion;
        }
        if(region.equals("us")){
            RegionMappingEnum regionMappingEnum = getUsRandom();
            aliResion = regionMappingEnum.getAliRegionApi();
        }else if(region.equals("mainland")){
            RegionMappingEnum regionMappingEnum = RegionMappingEnum.getCnRandom();
            aliResion = regionMappingEnum.getAliRegionApi();
        }else {
            aliResion = byRegion.getAliRegionApi();
        }
        return aliResion;
    }

    /**
     * @author Chen
     * @description 获取腾讯云映射 region
     * @date 2024/7/30 21:40
     */
    public static String getTenCentRegion(String region) {
        String tenCentResion = "";
        RegionMappingEnum byRegion = getByRegion(region);
        if(Objects.isNull(byRegion)){
            return tenCentResion;
        }
        if(region.equals("mainland")){
            RegionMappingEnum regionMappingEnum = RegionMappingEnum.getCnRandom();
            tenCentResion = regionMappingEnum.getTenCentRegionApi();
        }else {
            tenCentResion = byRegion.getTenCentRegionApi();
        }
        return tenCentResion;
    }
}
