package com.edgec.browserbackend.wxpay;

import java.io.InputStream;

public class FGLWxConfig extends WXPayConfig {
    @Override
    public String getAppID() {
        return "wx916a4651a3646d89";
    }

    @Override
    public String getMchID() {
        return "1685123963";
    }

    @Override
    public String getKey() {
        return "wj0808qwertyuiopasdfghjklzxcvbnm";
    }

    public int getHttpConnectTimeoutMs() {
        return 8000;
    }

    public int getHttpReadTimeoutMs() {
        return 10000;
    }

    @Override
    public InputStream getCertStream() {
        return getClass().getResourceAsStream("/certs/apiclient_cert.p12");
    }

    @Override
    public IWXPayDomain getWXPayDomain() {
        IWXPayDomain iwxPayDomain = new IWXPayDomain() {

            public void report(String domain, long elapsedTimeMillis, Exception ex) {

            }

            public DomainInfo getDomain(WXPayConfig config) {
                return new IWXPayDomain.DomainInfo(WXPayConstants.DOMAIN_API, true);
            }
        };
        return iwxPayDomain;

    }

    @Override
    public String getBody() {
        return "无界浏览器-用户充值";
    }

    @Override
    public String getWebUrl() {
        return "https://www.fangguanlian.cn/home/";
    }

}
