package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@NoArgsConstructor
@Getter
@Setter
@Document(collection = "notices")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Notice {

    @Id
    private String name;

    private String starDate;

    private String endDate;

    @Length(min = 0, max = 20000)
    private String content;

    public Notice(String starDate, String endDate, @Length(min = 0, max = 20000) String content) {
        this.starDate = starDate;
        this.endDate = endDate;
        this.content = content;
    }
}
