package com.edgec.browserbackend.account.domain;

import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.text.SimpleDateFormat;
import java.util.Date;

@Document(collection = "userwithdraw")
public class UserWithdraw {
    @Id
    private String id;

    private String tradeNo = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())+ SmsUtils.createRandom(true, 4);

    private String username;

    private int amount;

    private boolean succeed;

    private Date withdrawDate = new Date();

    private PaymentMethod withdrawMethod;

    private String transId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean isSucceed() {
        return succeed;
    }

    public void setSucceed(boolean succeed) {
        this.succeed = succeed;
    }

    public Date getWithdrawDate() {
        return withdrawDate;
    }

    public void setWithdrawDate(Date withdrawDate) {
        this.withdrawDate = withdrawDate;
    }

    public PaymentMethod getWithdrawMethod() {
        return withdrawMethod;
    }

    public void setWithdrawMethod(PaymentMethod withdrawMethod) {
        this.withdrawMethod = withdrawMethod;
    }

    public String getTransId() {
        return transId;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }
}
