package com.edgec.browserbackend.account.exception;

import com.edgec.browserbackend.common.commons.error.ErrorCode;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AccountErrorCode implements ErrorCode {

    /* client errors */

    UNKNOWN(ErrorCode.COMMON_UNKNOWN, "unknown"),
    NAMEEXIST(ACCOUNT_BASE + 100, "Username exists"),
    NAMENOTEXIST(ACCOUNT_BASE + 102, "Username does not exist"),
    EMAILEXIST(ACCOUNT_BASE + 101, "Email exists"),

    EMAILNOTEXIST(ACCOUNT_BASE + 103, "Email does not exist"),
    NAMEOREMAILNOTEXIST(ACCOUNT_BASE + 104, "Username or Email does not exist"),
    NOTALLOWEDTOCREATESUBUSER(ACCOUNT_BASE + 105, "The account isn't allowed to create sub user"),
    PHONEEXIST(ACCOUNT_BASE + 106, "Phone number exists"),
    OTPWRONG(ACCOUNT_BASE + 107, "otp invalid or expires"),
    OTPSENDFAILS(ACCOUNT_BASE + 108, "otp sends failure"),
    PHONENOTEXIST(ACCOUNT_BASE + 109, "Can not find account with phone number"),
    INVALIDTOKEN(ErrorCode.COMMON_INVALID_TOKEN, "Invalid token"),
    UNAUTHORIZED(ErrorCode.COMMON_UNAUTHRORIZED, "Unauthorized operation"),

    NAMEEMPTY(ACCOUNT_BASE + 110, "Username connot be empty"),
    EMAILEMPTY(ACCOUNT_BASE + 111, "Email connot be empty"),
    PHONEEMPTY(ACCOUNT_BASE + 112, "PhoneNumber connot be empty"),
    AGENCYNOEXIST(ACCOUNT_BASE + 113, "uuid dose not exists"),

    CHILDSCALINGSTATEUNABATED(ACCOUNT_BASE + 114, "Can't delete child whose still have scaling group "),

    BINDORDERERROR_NOTEXIST(ACCOUNT_BASE + 115, "This order is not exist"),

    BINDORDERERROR_BINDBYOTHERS(ACCOUNT_BASE + 116, "This order has been bind by others"),

    BINDORDERERROR_NOTQUALIFIED(ACCOUNT_BASE + 117, "You don't have free qualified"),

    BINDORDERERROR_HAVEORDER(ACCOUNT_BASE + 118, "You have an unpaid order"),

    BINDORDERERROR_NOTKNOW(ACCOUNT_BASE + 119, "Order generate error,please try again"),

    /* http request error */
    OTHERS(ErrorCode.COMMON_OTHERS, "http request error"),

    /* server errors */
    EMAILSENTERROR(ErrorCode.COMMON_SERVER_ERROR, "email sending error"),

    /**
     * wechat errors
     */
    WECHATERROR(ACCOUNT_BASE + 120, "Wechat order generation error"),

    /**
     * alipay errors
     */
    ALIPAYERROR(ACCOUNT_BASE + 130, "Alipay order generation error"),

    NOPERMISSION(ACCOUNT_BASE + 140, "You have no right to do this operarion"),
    GROUPMAX(ACCOUNT_BASE + 141, "You can not have more groups"),
    SHOPMAX(ACCOUNT_BASE + 142, "You can not have more shops"),
    CHILDMAX(ACCOUNT_BASE + 143, "You can not have more subUsers"),

    NOTENOUGHBALANCE(ErrorCode.ACCOUNT_BASE + 150, "Your balance is not enough");


    private final int code;
    private final String reason;

    private AccountErrorCode(int value, String reasonPhrase) {
        this.code = value;
        this.reason = reasonPhrase;
    }

    @Override
    public int value() {
        return this.code;
    }

    @Override
    @JsonValue
    public int getCode() {
        return code;
    }

    @Override
    public String toString() {
        return Integer.toString(this.code);
    }

    @Override
    public String getReason() {
        return reason;
    }
}
