package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;

public class FileRepositoryImpl implements FileRepository {

    private final Logger logger = LoggerFactory.getLogger(FileRepositoryImpl.class);

    @Autowired
    private GridFsTemplate gridFsTemplate;

    @Autowired
    private GridFsOperations operations;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    GridFSBucket gridFSBucket;


    @Override
    public String saveFile(MultipartFile file, String filename) {
        try {
            InputStream in = file.getInputStream();
            ObjectId id = gridFsTemplate.store(in, filename, file.getContentType());
            return id.toString();
        } catch (Exception e) {
            logger.error("存储文件时发生错误！！！", e);
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public String saveFile(File file, String filename) {
        try {
            InputStream in = new FileInputStream(file);
            ObjectId id = gridFsTemplate.store(in, filename);
            return id.toString();
        } catch (Exception e) {
            logger.error("存储文件时发生错误！！！", e);
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public void deleteFile(String fileId) {
        Query query = Query.query(Criteria.where("_id").is(fileId));
        // 查询单个文件
        GridFSFile gfsfile = gridFsTemplate.findOne(query);
        if (gfsfile == null) {
            return;
        }
        gridFsTemplate.delete(query);
    }

    @Override
    public File getFile(String fileId, String suffix) {
        Query query = Query.query(Criteria.where("_id").is(fileId));
        // 查询单个文件
        GridFSFile gridFSFile = gridFsTemplate.findOne(query);
        if (gridFSFile == null)
            return null;
        try {
            GridFSDownloadStream gridFSDownloadStream =
                    gridFSBucket.openDownloadStream(gridFSFile.getObjectId());
            GridFsResource gridFsResource = new GridFsResource(gridFSFile,gridFSDownloadStream);
            InputStream inputStream = gridFsResource.getInputStream();
            byte[] f = getBytes(inputStream);

            File file = new File(gridFSFile.getFilename() + suffix);
            FileOutputStream out = new FileOutputStream(file);
            out.write(f);
            out.close();
            return file;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }

    }
    private byte[] getBytes(InputStream inputStream) throws  Exception{
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int  i = 0;
        while (-1!=(i=inputStream.read(b))){
            bos.write(b,0,i);
        }
        return bos.toByteArray();
    }

    @Override
    public String updateFile(File file, String filename) {
        try {
            InputStream in = new FileInputStream(file);
            Query query = Query.query(Criteria.where("filename").is(filename));
            // 查询单个文件
            GridFSFile gridFSFile = gridFsTemplate.findOne(query);
            ObjectId id;
            if (gridFSFile == null)
                id = gridFsTemplate.store(in, filename);
            else {
                gridFsTemplate.delete(query);
                id = gridFsTemplate.store(in, filename);
            }
            in.close();
            return id.toString();
        } catch (Exception e) {
            logger.error("更新文件时发生错误！！！", e);
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }
}
