package com.edgec.browserbackend.account.service.impl;

import com.edgec.browserbackend.account.service.UserRateService;
import com.edgec.browserbackend.account.domain.UserRate;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.UserRateRepository;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class UserRateServiceImpl implements UserRateService {

    @Autowired
    private UserRateRepository userRateRepository;



    @Override
    public UserRate updateUserRate(String id, float money) {
        Optional<UserRate> optionalUserRate = userRateRepository.findById(id);
        if (optionalUserRate.isPresent()) {
            UserRate userRate = optionalUserRate.get();
            userRate.setRate(money);
            return userRateRepository.save(userRate);
        }
        return new UserRate();
    }

    @Override
    public boolean deleteUserRate(String userRateId) {
        userRateRepository.deleteById(userRateId);
        return true;
    }

    @Override
    public List<UserRate> getUserRate(String username) {
        List<UserRate> userRates = userRateRepository.findByUsername(username);
        if (userRates == null) userRates = new ArrayList<>();
        return userRates;
    }

    @Override
    public Page<UserRate> getUserRatePage(Pageable pageable) {
        return userRateRepository.findAll(pageable);
    }

    @Override
    public void addUserRate(UserRate userRate) {
        UserRate ourUserRate = userRateRepository.findByUsernameAndChargeTypeAndRegion(userRate.getUsername(), userRate.getChargeType(), userRate.getRegion());
        if (ourUserRate == null){
            userRateRepository.save(userRate);
        }else {
            throw new ClientRequestException(AccountErrorCode.NAMEEXIST, "record already exists: " + userRate.getRegion());
        }
    }


}
