package com.edgec.browserbackend.browser.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * 分配ip历史记录表
 *
 * @Author: Chen
 * @Date: 2024/08/14
 */
@Getter
@Setter
@NoArgsConstructor
@Document(collection = "ipHistory")
@JsonIgnoreProperties(ignoreUnknown = true)
public class IpHistory {
    @Id
    private String id;

    private String ipNo;//ipNo

    private String platformType;//云平台类型

    private long purchasedTime;
}
