package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.PlatformOptions;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author JMW
 */
public class PlatformOptionsRepositoryCustomImpl implements PlatformOptionsRepositoryCustom {

    @Autowired
    MongoTemplate mongoTemplate;

    @Override
    public boolean updatePlatformOptions(String platform, String subPlatform, String url) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("platform").is(platform));
        Update update = new Update();
        update.set("subPlatform." + subPlatform, url);
        return mongoTemplate.updateFirst(basicQuery, update, PlatformOptions.class).getMatchedCount() >= 1;

    }
}
