package com.edgec.browserbackend.account.scheduler;

import com.edgec.browserbackend.account.domain.CompanyMonthReport;
import com.edgec.browserbackend.account.repository.MonthReportRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.YearMonth;

@Component
public class PrepaidBillingCountTaskScheduler {

    private static final Logger log = LoggerFactory.getLogger(PrepaidBillingCountTaskScheduler.class);

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @Autowired
    private MonthReportRepository monthReportRepository;

    @Scheduled(cron = "0 0 5 1-3 * ?")
    @SchedulerLock(name = "countMonthlyPrepaid", lockAtMostForString = "PT90S", lockAtLeastForString = "PT60S")
    public void countMonthlyPrepaid() {
        final YearMonth lastmonth = YearMonth.now().minusMonths(1);
        int monthValue = lastmonth.getMonthValue();
        int year = lastmonth.getYear();

        for (int i = 2020; i <= year; i++){
            for (int j =1; j <= monthValue; j++){
                if (i == 2020 && j < 1){
                    continue;
                }else {
                    if (monthReportRepository.findByYearAndMonth(i,j) == null){
                        int count = new Long(userPrePaidBillingRepository.countPrepaidOrderNum(i, j)).intValue();
                        float companyExpenseAmount = userPrePaidBillingRepository.companyExpenseAmount(i, j);
                        float companyIncomeAmount = userPrePaidBillingRepository.companyIncomeAmount(i, j);
                        float companyWithdrawAmount = userPrePaidBillingRepository.companyWithdrawAmount(i, j);
                        float companyBankTransferAmount = userPrePaidBillingRepository.companyBankTransferAmount(i, j);
                        CompanyMonthReport companyMonthReport = new CompanyMonthReport();
                        companyMonthReport.setYear(i);
                        companyMonthReport.setMonth(j);
                        companyMonthReport.setBillingCount(count);
                        companyMonthReport.setCompanyExpenseAmount(companyExpenseAmount);
                        companyMonthReport.setCompanyIncomeAmount(companyIncomeAmount);
                        companyMonthReport.setCompanyWithDrawnAmount(companyWithdrawAmount);
                        companyMonthReport.setCompanyBankTransferAmount(companyBankTransferAmount);
                        monthReportRepository.save(companyMonthReport);
                    }else {
                        continue;
                    }
                }
            }
        }
    }
}
