package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.mongodb.client.result.UpdateResult;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.elasticsearch.common.recycler.Recycler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.SampleOperation;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class IpResourceRepositoryCustomImpl implements IpResourceRepositoryCustom {

    @Autowired
    MongoTemplate mongoTemplate;


    @Override
    public boolean lockTask(IpResource ipResource) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        Criteria criteria = new Criteria();
        criteria.orOperator(where("id").is(ipResource.getId()).and("isLocked").is(false).and("status").is(ipResource.getStatus()).and("isDeleted").is(false),
                where("lockTimestamp").lte(Instant.now().minusSeconds(300).toEpochMilli()).and("status").is(ipResource.getStatus()).and("isDeleted").is(false));
        basicQuery.addCriteria(criteria);
        Update update = new Update();
        update.set("isLocked", true).set("lockTimestamp", Instant.now().toEpochMilli());
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, IpResource.class);

        if (result.getModifiedCount() < 1)
            return false;
        else
            return true;
    }

    @Override
    public boolean unLockTask(String id) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("id").is(id));
        Update update = new Update();
        update.set("isLocked", false).set("lockTimestamp", Instant.now().toEpochMilli());
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, IpResource.class);

        if (result.getModifiedCount() < 1)
            return false;
        else
            return true;
    }

    @Override
    public boolean healthLock(IpResource ipResource) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        Criteria criteria = new Criteria();
        criteria.orOperator(where("id").is(ipResource.getId()).and("isLocked").is(false).and("status").is(ipResource.getStatus()).and("isDeleted").is(false),
                where("healthLockTimestamp").lte(Instant.now().minusSeconds(300).toEpochMilli()).and("status").is(ipResource.getStatus()).and("isDeleted").is(false));
        basicQuery.addCriteria(criteria);
        Update update = new Update();
        update.set("isLocked", true).set("healthLockTimestamp", Instant.now().toEpochMilli());
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, IpResource.class);

        if (result.getModifiedCount() < 1)
            return false;
        else
            return true;
    }

    @Override
    public boolean unLockHealth(String id) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("id").is(id));
        Update update = new Update();
        update.set("isLocked", false).set("healthLockTimestamp", Instant.now().toEpochMilli());
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, IpResource.class);

        if (result.getModifiedCount() < 1)
            return false;
        else
            return true;
    }

    @Override
    public List<IpResource> sampleTasks(int status, long timestamp) {
        Criteria matchCriteria  = new Criteria();
        matchCriteria.orOperator(where("status").is(status).and("isLocked").is(false).and("isDeleted").is(false),
                where("status").is(status).and("isLocked").is(true).and("lockTimestamp").lte(timestamp).and("isDeleted").is(false));

        MatchOperation match = Aggregation.match(matchCriteria);

        SampleOperation sample = Aggregation.sample(20);
        AggregationResults<IpResource> results = mongoTemplate.aggregate(Aggregation.newAggregation(match, sample), IpResource.class, IpResource.class);
        List<IpResource> mappedResults = results.getMappedResults();

        return mappedResults;
    }

    @Override
    public List<IpResource> sampleTasks(List<Integer> status) {
        Criteria matchCriteria  = new Criteria();
        matchCriteria.orOperator(where("status").in(status).and("isLocked").is(false).and("isDeleted").is(false).and("healthLockTimestamp").lte(Instant.now().minusSeconds(60*30).toEpochMilli()),
                where("status").in(status).and("isLocked").is(true).and("healthLockTimestamp").lte(Instant.now().minusSeconds(300).toEpochMilli()).and("isDeleted").is(false));

        MatchOperation match = Aggregation.match(matchCriteria);

        SampleOperation sample = Aggregation.sample(20);
        AggregationResults<IpResource> results = mongoTemplate.aggregate(Aggregation.newAggregation(match, sample), IpResource.class, IpResource.class);
        List<IpResource> mappedResults = results.getMappedResults();

        return mappedResults;
    }

}
