package com.edgec.browserbackend.common.utils;
import com.edgec.browserbackend.common.commons.utils.NotifyUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Trans {
    private final Logger logger = LoggerFactory.getLogger(Trans.class);
    static int timeout = 10 * 1000;// 以秒为单位
    private static String specialHost = "39.108.183.128";//117.177.243.7
    private static int specialPort = 20008;
    private String host;
    private int port;
    private String username;
    private String password;

    public Trans(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.username = username;
    }

    public Trans(String username, String password) {
        this.host = specialHost;
        this.port = specialPort;
        this.password = password;
        this.username = username;
    }

    /**
     * 主入口方法
     * @param args
     */
    public static void main(String[] args) {
        String url = "http://pv.sohu.com/cityjson";
        Trans trans = new Trans("120.76.135.212", 20001, "fangguanlianbrowser", "2rbvtg9GQ1JraA1");
        String result = trans.get(url, false);
    }

    public HttpClient getHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(
                new AuthScope(host, port),
                new UsernamePasswordCredentials(username, password));
        HttpHost proxy = new HttpHost(host,port);
        httpClient.getParams().setParameter(ConnRouteParams.DEFAULT_PROXY, proxy);
        return httpClient;
    }

    /**
     * 向指定URL发送GET方法的请求
     */
    public String get(String url, boolean special) {
        StringBuffer sb = new StringBuffer();
        //创建HttpClient实例
        HttpClient client = this.getHttpClient();
        //创建httpGet
        HttpGet httpGet = new HttpGet("http://pv.sohu.com/cityjson");
        //执行
        try {
            HttpResponse response = client.execute(httpGet);

            HttpEntity entry = response.getEntity();

            if(entry != null)
            {
                InputStreamReader is = new InputStreamReader(entry.getContent());
                BufferedReader br = new BufferedReader(is);
                String str = null;
                while((str = br.readLine()) != null)
                {
                    sb.append(str.trim());
                }
                br.close();
            }

        } catch (ClientProtocolException e) {
            NotifyUtils.sendMessage("防关联浏览器 ip " + host + " 代理异常", e, NotifyUtils.MsgType.WEBHOOK);
            logger.error(e.getMessage(), e);
            return "";
        } catch (IOException e) {
            NotifyUtils.sendMessage("防关联浏览器 ip " + host + " 代理异常", e, NotifyUtils.MsgType.WEBHOOK);
            logger.error(e.getMessage(), e);
            return "";
        }
        return sb.toString();
    }
}