package com.edgec.browserbackend.auth.service.security;

import com.edgec.browserbackend.auth.domain.Roles;
import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.repository.RolesRepository;
import com.edgec.browserbackend.auth.repository.UserRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;


import java.util.*;

@Service
public class MongoUserDetailsService implements UserDetailsService {

    @Autowired
    private UserRepository repository;

    @Autowired
    private RolesRepository rolesRepository;

    private final List<String> TEMPORARY_ACCESS_USERNAME_SUFFIX = Arrays.asList("@intellicost");

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {

        User user = repository.findById(username).orElse(null);

        if (user == null && !StringUtils.isEmpty(username) && username.contains("@")) {
            user = repository.findByEmail(username).orElse(null);
        }

        if (user == null && !StringUtils.isEmpty(username) && StringUtils.isNumeric(username)) {
            user = repository.findByPhone(username).orElse(null);
        }

        if (user == null) {
            try {
                user = genTemporaryAccessUser(username);
            } catch (Exception e) {
                e.printStackTrace();
                user = null;
            }
        }

        if (user == null)
            throw new UsernameNotFoundException(username);

        Optional<Roles> roles = rolesRepository.findById(username);

        if (roles.isPresent() && !StringUtils.isEmpty(roles.get().getRoles())) {

            String[] userRoles = roles.get().getRoles().split(",");

            List<GrantedAuthority> authorities = new ArrayList<>();
            for (String userRole : userRoles) {
                SimpleGrantedAuthority role = new SimpleGrantedAuthority("ROLE_" + userRole);
                authorities.add(role);
            }
            user.setAuthorities(authorities);
        }

        return user;
    }

    /**
     * For angelia and intellicost temporary access
     *
     * @param username uuid@intellicost
     * @return
     */
    private User genTemporaryAccessUser(String username) {
        if (StringUtils.isBlank(username) || TEMPORARY_ACCESS_USERNAME_SUFFIX.stream().noneMatch(username::contains)) {
            return null;
        }

        User temporaryUser = new User();
        temporaryUser.setUsername(username);
        temporaryUser.setEmail(username);
        temporaryUser.setEnabled(true);
        String pwd = username.split("@")[0];
        temporaryUser.setPassword(new BCryptPasswordEncoder().encode(Base64.getEncoder().encodeToString(pwd.getBytes())));
        return temporaryUser;
    }
}
