package com.edgec.browserbackend.browser.domain;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.math.BigDecimal;

/**
 * @author xuxin
 * @date 2020/8/3 14:37
 * @description 用来存放一些全局变量
 */
@Data
@Document(collection = "globalfield")
public class GlobalField {
    @Id
    private String id;

    /**
     * 专线状态
     * on：正常
     * off: 挂掉了
     */
    private String specialLineState;

    /**
     * 注册礼金
     * 目前是注册就送 16 元
     */
    private Integer registerGift;

    /**
     * 分销商提成比例
     * 目前是 0.30
     */
    private BigDecimal distributorRate;
}
