package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String>, IpResourceRepositoryCustom {
    IpResource findByAddr(String addr);

    IpResource findByAddrAndIsDeletedAndIsLocked(String addr, boolean isDeleted, boolean isLocked);

    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);

    IpResource findByIdAndIsDeletedAndIsLocked(String id, boolean isDeleted, boolean isLocked);

    IpResource findByIdAndIsDeleted(String id, boolean isDeleted);

    Page<IpResource> findByIdInAndIsDeletedOrderByPurchasedTimeDesc(List<String> ipIds, boolean isDeleted, Pageable pageable);

    List<IpResource> findByOwnerAndIsDeletedAndBind(String owner, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerAndStatusIsNotInAndIsDeletedAndBind(String owner, List<Integer> status, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerAndStatusInAndIsDeletedAndBind(String owner, List<Integer> status, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerAndStatusAndIsDeletedAndBind(String owner, int status, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerInAndIsDeletedAndBind(List<String> owner, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerInAndStatusIsNotInAndIsDeletedAndBind(List<String> owner, List<Integer> status, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerInAndStatusInAndIsDeletedAndBind(List<String> owner, List<Integer> status, boolean isDeleted, boolean bind);

    List<IpResource> findByOwnerInAndStatusAndIsDeletedAndBind(List<String> owner, int status, boolean isDeleted, boolean bind);

    Page<IpResource> findByIsDeletedAndIdInAndAddrLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String addr, Pageable pageable);

    Page<IpResource> findByIsDeletedAndIdInAndVendorCnLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String vendorCn, Pageable pageable);

    Page<IpResource> findByIsDeletedAndIdInAndVendorLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String vendor, Pageable pageable);

    Page<IpResource> findByIsDeletedAndIdInAndRegionCnLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String region, Pageable pageable);

    List<IpResource> findByIsDeleted(boolean isDeleted);

    List<IpResource> findByOwnerInAndSpecialLine(List<String> owners, boolean specialLine);

    List<IpResource> findBySpecialLineAndIsDeleted(boolean specialLine, boolean isDeleted);

    List<IpResource> findByRegionInAndIsDeleted(List<String> regions, boolean isDeleted);

    List<IpResource> findByStatusAndLockedAndLockTimestampLessThan(int status, boolean locked, long timestamp);

    List<IpResource> findByValidTimeBetweenAndIsDeleted(long beginTime, long endTime, boolean isDeleted);

    IpResource findFirstByShopIdsIsAndIsDeleted(String shopId, boolean isDeleted);

    int countByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);

    long countAllByIsDeletedAndValidTimeGreaterThan(boolean isDeleted, long time);

    long countAllByOwnerAndIsDeletedAndValidTimeGreaterThan(String username, boolean isDeleted, long time);

    long countAllByOwnerInAndIsDeletedAndValidTimeGreaterThan(List<String> username, boolean isDeleted, long time);

    long countAllByOwner(String username);


    IpResource findFirstByAddrOrderByPurchasedTimeDesc(String addr);

    /**
     * 查询出未分配成功的数据
     *
     * @param status 状态
     * @param isDeleted 是否被删除
     * @param isLocked 是否被锁定
     * @return list
     */
    List<IpResource> findByStatusInAndIsDeletedAndIsLocked(List<Integer> status, boolean isDeleted, boolean isLocked);

    List<IpResource> findByValidTimeLessThanAndIsDeleted(long toEpochMilli, boolean b);
}
