package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.IpType;
import com.edgec.browserbackend.browser.domain.Shop;
import com.google.gson.internal.$Gson$Preconditions;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String>, IpResourceRepositoryCustom {
    IpResource findByAddr(String addr);
    IpResource findByAddrAndIsDeletedAndIsLocked(String addr, boolean isDeleted, boolean isLocked);
    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);
    IpResource findByIdAndIsDeletedAndIsLocked(String id, boolean isDeleted, boolean isLocked);
    IpResource findByIdAndIsDeleted(String id, boolean isDeleted);
    List<IpResource> findByShopIdInAndIsDeleted(List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByIdInAndIsDeletedOrderByPurchasedTimeDesc(List<String> ipIds, boolean isDeleted, Pageable pageable);
    List<IpResource> findByOwnerAndIsDeletedAndShopIdIsNull(String owner, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusIsNotInAndIsDeletedAndShopIdIsNull(String owner, List<Integer> status, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(String owner, int status, boolean isDeleted);
    List<IpResource> findByOwnerInAndIsDeletedAndShopIdIsNull(List<String> owner, boolean isDeleted);
    List<IpResource> findByOwnerInAndStatusIsNotInAndIsDeletedAndShopIdIsNull(List<String> owner, List<Integer> status, boolean isDeleted);
    List<IpResource> findByOwnerInAndStatusAndIsDeletedAndShopIdIsNull(List<String> owner, int status, boolean isDeleted);
    List<IpResource> findByStatusAndShopIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByIsDeletedAndIdInAndAddrLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String addr, Pageable pageable);
    Page<IpResource> findByIsDeletedAndIdInAndVendorCnLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String vendorCn, Pageable pageable);
    Page<IpResource> findByIsDeletedAndIdInAndVendorLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String vendor, Pageable pageable);
    Page<IpResource> findByIsDeletedAndIdInAndRegionCnLikeOrderByPurchasedTimeDesc(boolean isDeleted, List<String> ipIds, String region, Pageable pageable);
    List<IpResource> findByIsDeletedAndShopIdInAndRegionCnLike(boolean isDeleted, List<String> shopIds, String regionCn);

    List<IpResource> findByIsDeleted(boolean isDeleted);

    List<IpResource> findByOwnerInAndSpecialLine(List<String> owners, boolean specialLine);
    List<IpResource> findBySpecialLineAndIsDeleted(boolean specialLine, boolean isDeleted);

    List<IpResource> findByRegionInAndIsDeleted(List<String> regions, boolean isDeleted);

    List<IpResource> findByStatusAndLockedAndLockTimestampLessThan(int status, boolean locked, long timestamp);

    List<IpResource> findByValidTimeBetweenAndIsDeleted(long beginTime, long endTime, boolean isDeleted);

    IpResource findFirstByShopIdAndIsDeleted(String shopId, boolean isDeleted);

    int countByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);

    long countAllByIsDeletedAndValidTimeGreaterThan(boolean isDeleted, long time);

    long countAllByOwnerAndIsDeletedAndValidTimeGreaterThan(String username, boolean isDeleted, long time);
    long countAllByOwnerInAndIsDeletedAndValidTimeGreaterThan(List<String> username, boolean isDeleted, long time);
    long countAllByOwner(String username);
}
