package com.edgec.browserbackend.account.scheduler;

import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.UserBalanceRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import com.edgec.browserbackend.account.service.UserLackMoneyService;
import com.edgec.browserbackend.account.service.UserPrePaidBillingService;
import com.edgec.browserbackend.account.utils.AccountServicePool;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Component
public class BillingTaskScheduler {

    private static final Logger log = LoggerFactory.getLogger(BillingTaskScheduler.class);

    @Autowired
    private AccountRepository repository;

    @Autowired
    private UserPrePaidBillingService userPrePaidBillingService;

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @Autowired
    private UserBalanceRepository userBalanceRepository;

    @Autowired
    private UserLackMoneyService userLackMoneyService;

//    @Scheduled(cron = "0 0 3 2-4 * ?")
//    public void computeMonthlyBills() {
//
//        final PageRequest request = PageRequest.of(0, 100);
//
//        Page<Account> users = repository.findByParentIsNull(request);
//
//        int pageSize = users.getTotalPages();
//
//        final YearMonth lastmonth = YearMonth.now().minusMonths(1);
//
//        int monthValue = lastmonth.getMonthValue();
//        int year = lastmonth.getYear();
//
//        for (int i = 0; i < pageSize; i++) {
//
//            if (i > 0)
//                users = repository.findByParentIsNull(PageRequest.of(i, 100));
//
//            List<Account> currentAcounts = users.getContent();
//
//            if (currentAcounts != null && currentAcounts.size() > 0) {
//
//                currentAcounts.forEach(x -> {
//
//                    List<UserService> userServices = x.getUserServices();
//
//                    if (userServices == null || userServices.size() <= 0)
//                        return;
//
//                    //only one service 'intelligroup' currently.
//                    UserService userService = userServices.get(0);
//                    if (userService.getServiceType().equals(ServiceType.FORMAL) || userService.getServiceType().equals(ServiceType.TRIAL)) {
//                        try {
//                            List<UserPrePaidBilling> bill = userPrePaidBillingRepository.findByUsernameAndServicesAndYearAndMonth(x.getName(), userService.getServiceName().toString(), year, monthValue);
//                            if (bill.size() == 0)
//                                updateBillForMonth(x, userService, year, monthValue);
//                        } catch (Exception e) {
//                            log.error("Month bill generation fails, user: {}, year: {}, month: {}", x.getName(), year, monthValue, e);
//                        }
//                    }
//                });
//            }
//        }
//
//    }

//    private void updateBillForMonth(Account account, UserService service, int year, int month) {
//        List<Account> children = repository.findByParent(account.getName());
//        if (children != null && children.size() > 0) {
//            for (Account child : children) {
//                upsertAccountMonthBill(child, service, year, month);
//            }
//        }
//        upsertAccountMonthBill(account, service, year, month);
//    }

//    private void upsertAccountMonthBill(Account account, UserService service, int year, int month) {
//        List<UserPrePaidBilling> existing = userPrePaidBillingRepository.findByUsernameAndServicesAndYearAndMonth(account.getName(), service.getServiceName().toString(), year, month);
//        if (existing.size() == 0) {
//            UserBillDto bill = cloudService.getMonthlyBills(account.getName(), year, month);
//            float potential = bill.getOwnPotentialCost();
//            float actual = bill.getOwnActualCost();
//            float diff = potential - actual;
//            if (diff < 0)
//                diff = 0;
//            float ownBillCost = Math.round(diff * service.getDiscount() / 100.0f);
//            float total = ownBillCost;
//            BillStatus billStatus = BillStatus.UNPAID;
//            if (total == 0) {
//                billStatus = BillStatus.PAID;
//            }
//            boolean isPrepaid = false;
//            int chargeType = 9;
//            String user = account.getName();
//            String target;
//            if (StringUtils.isEmpty(account.getParent())) {
//                target = account.getName() + "创建的云端伸缩组(" + month + "月)";
//                userPrePaidBillingRepository.upsertBillOwnCost(account.getName(), service.getServiceName().toString(), year, month, Instant.now().toEpochMilli(), potential, actual, ownBillCost, total, billStatus, isPrepaid, user, chargeType, target);
//            } else {
//                target = "子用户" + account.getName() + "创建的云端伸缩组(" + month + "月)";
//                userPrePaidBillingRepository.upsertBillOwnCost(account.getParent(), service.getServiceName().toString(), year, month, Instant.now().toEpochMilli(), potential, actual, ownBillCost, total, billStatus, isPrepaid, user, chargeType, target);
//                userPrePaidBillingRepository.upsertBillOwnCost(account.getName(), service.getServiceName().toString(), year, month, Instant.now().toEpochMilli(), potential, actual, ownBillCost, total, BillStatus.PARENTSHALLPAY, isPrepaid, user, chargeType, target);
//            }
//        }
//    }

    @Scheduled(cron = "0 0 0 * * ?")
    public void updateUserBillingAndBalance() {
        CompletableFuture.runAsync(() -> {
            List<UserPrePaidBilling> billings = userPrePaidBillingRepository.findByStatus(BillStatus.UNPAID);
            for (UserPrePaidBilling billing : billings) {
                UserBalance balance = userBalanceRepository.findById(billing.getUsername()).orElse(null);
                float shouldPayAmount;
                if (billing.getDeductionRecords() == null) {
                    shouldPayAmount = billing.getTotal();
                } else {
                    List<DeductionRecord> deductionAmount = billing.getDeductionRecords();
                    shouldPayAmount = billing.getTotal() - ((Double) deductionAmount.stream().mapToDouble(DeductionRecord::getDeductionAmount).sum()).floatValue();
                }
                if (balance == null || balance.getBalanced() < 1) {
                } else {
                    DeductionRecord deductionRecord = new DeductionRecord();
                    deductionRecord.setDeductionTime(Instant.now().getEpochSecond());
                    billing.addDeductionRecord(deductionRecord);
                    if (balance.getBalanced() < shouldPayAmount) {
                        float affordable = balance.getBalanced();
                        deductionRecord.setDeductionAmount(affordable);
                        if (userPrePaidBillingRepository.updateBillStatus(billing.getId(), BillStatus.UNPAID, BillStatus.UNPAID, billing.getDeductionRecords()) == 1) {
                            userBalanceRepository.incrementBalance(balance, -affordable, affordable);
                        }
                        break;
                    } else {
                        deductionRecord.setDeductionAmount(shouldPayAmount);
                        if (userPrePaidBillingRepository.updateBillStatus(billing.getId(), BillStatus.UNPAID, BillStatus.PAID, billing.getDeductionRecords()) == 1) {
                            userBalanceRepository.incrementBalance(balance, -shouldPayAmount, shouldPayAmount);
                        }
                    }
                }
            }
            updateAllUserLackMoney();
        }, AccountServicePool.taskPool);
    }

    private void updateAllUserLackMoney(){
        List<UserPrePaidBilling> unpaidBillings = userPrePaidBillingRepository.findAll();
        Map<String, List<UserPrePaidBilling>> userPrePaidBillingMap = unpaidBillings.stream().collect(Collectors.groupingBy(UserPrePaidBilling::getUsername));
        for (Map.Entry<String, List<UserPrePaidBilling>> entry : userPrePaidBillingMap.entrySet()) {
            userLackMoneyService.updateLackMoney(entry.getValue(), false);
        }

    }

}
