package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.common.commons.utils.UniquePriorityBlockingQueue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public abstract class ThreadPoolUtils {

    public static final BlockingQueue<Runnable> schedulerQueue = new UniquePriorityBlockingQueue<>(50);


    private static final int TASK_POOL_COUNT = 20;

    public static final ExecutorService buyIpTasksPool = Executors.newFixedThreadPool(TASK_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-buyIp-task-" + count++);
        }
    });


    private static final int TIME_SCHEDULER_POOL_COUNT = 20;

    public static final ExecutorService queryIpTasksPool = Executors.newFixedThreadPool(TIME_SCHEDULER_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-queyrIp-task-" + count++);
        }
    });


    private static final int IPTRANSACTION_POOL_COUNT = 20;

    public static final ExecutorService queryIpHealth = Executors.newFixedThreadPool(IPTRANSACTION_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-ipHealthCheck-task-" + count++);
        }
    });
}
