package com.edgec.browserbackend.account.domain;

import com.edgec.browserbackend.account.dto.CompanyAuthorizeDto;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "companyauthorize")
public class CompanyAuthorize {
    @Id
    private String id;
    private String username;
    private int type; //0 -- 企业, 1 -- 个体工商户
    private String companyName;
    private String registerNumber;
    private String companyLicenseId;

    private String coporationPlace;
    private String coporationLicenseFront;
    private String coporationLicenseBack;
    private int writePerson; //0 -- 法定代表人, 1 -- 代理人

    private String agencyFront;
    private String agencyBack;

    public CompanyAuthorize() {

    }

    public CompanyAuthorize(CompanyAuthorizeDto companyAuthorizeDto) {
        if (companyAuthorizeDto.getUsername() != null)
            this.username = companyAuthorizeDto.getUsername();
        this.type = companyAuthorizeDto.getType();
        if (companyAuthorizeDto.getCompanyName() != null)
            this.companyName = companyAuthorizeDto.getCompanyName();
        if (companyAuthorizeDto.getRegisterNumber() != null)
            this.registerNumber = companyAuthorizeDto.getRegisterNumber();
        if (companyAuthorizeDto.getCoporationPlace() != null)
            this.coporationPlace = companyAuthorizeDto.getCoporationPlace();
        this.writePerson = companyAuthorizeDto.getWritePerson();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public int getWritePerson() {
        return writePerson;
    }

    public void setCoporationPlace(String coporationPlace) {
        this.coporationPlace = coporationPlace;
    }


    public String getCoporationPlace() {
        return coporationPlace;
    }


    public void setRegisterNumber(String registerNumber) {
        this.registerNumber = registerNumber;
    }

    public void setWritePerson(int writePerson) {
        this.writePerson = writePerson;
    }


    public String getRegisterNumber() {
        return registerNumber;
    }

    public String getAgencyBack() {
        return agencyBack;
    }

    public void setAgencyBack(String agencyBack) {
        this.agencyBack = agencyBack;
    }

    public String getAgencyFront() {
        return agencyFront;
    }

    public void setAgencyFront(String agencyFront) {
        this.agencyFront = agencyFront;
    }

    public String getCompanyLicenseId() {
        return companyLicenseId;
    }

    public void setCompanyLicenseId(String companyLicenseId) {
        this.companyLicenseId = companyLicenseId;
    }

    public String getCoporationLicenseBack() {
        return coporationLicenseBack;
    }

    public void setCoporationLicenseBack(String coporationLicenseBack) {
        this.coporationLicenseBack = coporationLicenseBack;
    }

    public String getCoporationLicenseFront() {
        return coporationLicenseFront;
    }

    public void setCoporationLicenseFront(String coporationLicenseFront) {
        this.coporationLicenseFront = coporationLicenseFront;
    }
}
