package com.edgec.browserbackend.account.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class AccountServicePool {

    private static final int POOL_COUNT = 10;

    public static final ExecutorService taskPool = Executors.newFixedThreadPool(
            POOL_COUNT,
            new ThreadFactory() {
                int count = 1;

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "account-service-pool" + count++);
                }
            }
    );

}
