package com.edgec.browserbackend.auth.domain;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

@Document(collection = "userattemptslogin")
public class UserAttemptsLogin {

    @Id
    private String username;

    private int attempts;

    private Date date = new Date();

    public UserAttemptsLogin(String username, int attempts) {
        this.username = username;
        this.attempts = attempts;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getAttempts() {
        return attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}