package com.edgec.browserbackend.auth.service;


import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.domain.UserPasswordReset;

public interface UserService {

    void create(User user);

    void verifyCode(String name, String code);

    void reset(User user);

    void lock(User user, String lock);

    void unlock(User user, String unlock);

    boolean changePassword(UserPasswordReset userPasswordReset);

    void deleteUser(String name);

    void resetUserPassword(User user);

    boolean lockState(String name);

    void updateRoles(String name, String roles);

    void addRoles(String name, String roles);

    void updateUser(String username, User user);

}
