package com.edgec.browserbackend.browser.domain;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author cloudam
 * 这是一个中间表，关联 user 、shop、 group 表
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Document(collection = "usershop")
public class UserShop {

    @Id
    private String id;

    private String username;

    private String shopId;

    private String groupId;

    public UserShop(String username, String shopId) {
        this.username = username;
        this.shopId = shopId;
    }

    public UserShop(String username, String shopId, String groupId) {
        this(username, shopId);
        this.groupId = groupId;
    }
}
