package com.edgec.browserbackend.browser.service.Impl;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.Group;
import com.edgec.browserbackend.browser.dto.GroupDto;
import com.edgec.browserbackend.browser.repository.GroupRepository;
import com.edgec.browserbackend.browser.repository.UserShopRepository;
import com.edgec.browserbackend.browser.service.GroupService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class GroupServiceImpl implements GroupService {

    private final Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private GroupRepository groupRepository;

    @Autowired
    private UserShopRepository userShopRepository;

    @Override
    public String addGroup(String username, String groupName) {
        if (StringUtils.isBlank(username) || StringUtils.isBlank(groupName))
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        Account account = accountRepository.findByName(username).orElseThrow(() -> new ClientRequestException(AccountErrorCode.NAMENOTEXIST));
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getGroupCount() >= 100)
            throw new ClientRequestException(AccountErrorCode.GROUPMAX);
        Group group = new Group();
        group.setOwner(username);
        group.setName(groupName);
        String id;
        try {
            Group group1 = groupRepository.save(group);
            //可以优化
            account.setGroupCount(account.getGroupCount() + 1);
            accountRepository.save(account);
            id = group1.getId();
        } catch (Exception e) {
            logger.error("fail to add group", e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
        return id;
    }

    @Override
    public void updateGroup(String username, Group group) {
        if (group == null || StringUtils.isBlank(username))
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        Group group1 = groupRepository.findById(group.getId()).orElse(null);
        if (group1 == null)
            throw new ClientRequestException(BrowserErrorCode.GROUPNOTEXIST);
        try {
            group1.of(group);
            groupRepository.save(group1);
        } catch (Exception e) {
            logger.error("fail to update group", e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public void deleteGroup(String username, String groupId) {
        if (StringUtils.isBlank(username) || StringUtils.isBlank(groupId))
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        Account account = accountRepository.findByName(username).orElseThrow(() -> new ClientRequestException(AccountErrorCode.NAMENOTEXIST));
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        try {
            userShopRepository.updateGroupId(groupId, null);
            groupRepository.deleteById(groupId);
            //可以优化
            account.setGroupCount(account.getGroupCount() - 1);
            accountRepository.save(account);
        } catch (Exception e) {
            logger.error("fail to delete group", e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public List<GroupDto> getGroupList(String username) {
        if (StringUtils.isBlank(username))
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        List<Group> groups = groupRepository.findByOwner(username);
        if (groups == null)
            return new ArrayList<>();
        List<GroupDto> groupDtos = new ArrayList<>();
        try {
            groups.stream().forEach(x -> {
                groupDtos.add(new GroupDto(x.getId(), x.getName(), x.getDetails()));
            });
        } catch (Exception e) {
            logger.error("fail to delete group", e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
        return groupDtos;
    }
}
