package com.edgec.browserbackend.account.dto;

import com.edgec.browserbackend.account.domain.CompanyAuthorize;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.web.multipart.MultipartFile;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CompanyAuthorizeDto {
    private String username;
    private int type; //0 -- 企业, 1 -- 个体工商户
    private String companyName;
    private String registerNumber;
    private MultipartFile companyLicense;

    private String coporationPlace;
    private MultipartFile coporationLicense_front;
    private MultipartFile coporationLicense_back;
    private int writePerson; //0 -- 法定代表人, 1 -- 代理人

    private MultipartFile agency_front;
    private MultipartFile agency_back;

    public CompanyAuthorizeDto() {

    }

    public CompanyAuthorizeDto(CompanyAuthorize companyAuthorize) {
        if (companyAuthorize.getUsername() != null)
            this.username = companyAuthorize.getUsername();
        this.type = companyAuthorize.getType();
        if (companyAuthorize.getCompanyName() != null)
            this.companyName = companyAuthorize.getCompanyName();
        if (companyAuthorize.getRegisterNumber() != null)
            this.registerNumber = companyAuthorize.getRegisterNumber();
        if (companyAuthorize.getCoporationPlace() != null)
            this.coporationPlace = companyAuthorize.getCoporationPlace();
        this.writePerson = companyAuthorize.getWritePerson();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRegisterNumber() {
        return registerNumber;
    }

    public void setWritePerson(int writePerson) {
        this.writePerson = writePerson;
    }

    public void setRegisterNumber(String registerNumber) {
        this.registerNumber = registerNumber;
    }

    public String getCoporationPlace() {
        return coporationPlace;
    }

    public void setCoporationPlace(String coporationPlace) {
        this.coporationPlace = coporationPlace;
    }

    public int getWritePerson() {
        return writePerson;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public MultipartFile getAgency_back() {
        return agency_back;
    }

    public void setAgency_back(MultipartFile agency_back) {
        this.agency_back = agency_back;
    }

    public MultipartFile getAgency_front() {
        return agency_front;
    }

    public void setAgency_front(MultipartFile agency_front) {
        this.agency_front = agency_front;
    }

    public MultipartFile getCompanyLicense() {
        return companyLicense;
    }

    public void setCompanyLicense(MultipartFile companyLicense) {
        this.companyLicense = companyLicense;
    }

    public MultipartFile getCoporationLicense_front() {
        return coporationLicense_front;
    }

    public void setCoporationLicense_front(MultipartFile coporationLicense_front) {
        this.coporationLicense_front = coporationLicense_front;
    }

    public MultipartFile getCoporationLicense_back() {
        return coporationLicense_back;
    }

    public void setCoporationLicense_back(MultipartFile coporationLicense_back) {
        this.coporationLicense_back = coporationLicense_back;
    }
}
