package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.CloudUserOrder;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/2/11 5:49 下午
 **/
@Repository
public interface CloudUserOrderRepository extends MongoRepository<CloudUserOrder, String>, AccountRepositoryCustom  {
    CloudUserOrder findByTradeNoAndUsername(String tradeNo, String username);
    List<CloudUserOrder> findByStatusAndUsernameOrderByOrderTimeStampDesc(String status, String username);
    List<CloudUserOrder> findByUsernameOrderByOrderTimeStampDesc(String username);
    List<CloudUserOrder> findByServiceAndUsernameOrderByOrderTimeStampDesc(String service, String username);
    List<CloudUserOrder> findByServiceAndStatusAndUsernameOrderByOrderTimeStampDesc(String service, String status, String username);
    List<CloudUserOrder> findByStatusIn(List<String> status);
    List<CloudUserOrder> findByUsernameIsNullAndStatus(String status);

    CloudUserOrder findByTradeNo(String tradeNo);
}
