package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.UserPayment;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class UserPaymentRepositoryCustomImpl implements UserPaymentRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean updatePaymentResult(UserPayment payment, boolean result) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("id").is(payment.getId()).and("succeed").is(!result));
        Update update = new Update();
        update.set("succeed", result);
        UpdateResult operation = mongoTemplate.updateFirst(basicQuery, update, UserPayment.class);

        if (operation.getModifiedCount() < 1)
            return false;
        else
            return true;
    }
}

