package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResourceDto {
    private String id;
    private String addr;
    private Vendor vendor;
    private String region;
    //0:正常, 1:已过期, 2:即将过期, 3:正在分配, 4:未使用
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String username;
    private String details;
    private String password;
    private List<String> protocol;
    ShopDto bindShop;
    private List<BindHistory> bindHistories;

    public IpResourceDto(){
    }

    public IpResourceDto(IpResource ipResource, ShopDto shopDto, boolean useHistory){
        this.id = ipResource.getId();
        this.addr = ipResource.getAddr();
        this.vendor = ipResource.getVendor();
        this.region = ipResource.getRegion();
        this.status = ipResource.getStatus();
        this.port = ipResource.getPort();
        this.purchasedTime = ipResource.getPurchasedTime();
        this.validTime = ipResource.getValidTime();
        this.username = ipResource.getUsername();
        this.details = ipResource.getDetails();
        this.password = ipResource.getPassword();
        this.protocol = ipResource.getProtocol();
        this.bindShop = shopDto;
        if (useHistory)
            this.bindHistories = ipResource.getBindHistory();
        else
            this.bindHistories = new ArrayList<>();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getPort() {
        return port;
    }

    public void setPort(List<String> port) {
        this.port = port;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public long getValidTime() {
        return validTime;
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime;
    }

    public long getPurchasedTime() {
        return purchasedTime;
    }

    public void setPurchasedTime(long purchasedTime) {
        this.purchasedTime = purchasedTime;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ShopDto getBindShop() {
        return bindShop;
    }

    public void setBindShop(ShopDto bindShop) {
        this.bindShop = bindShop;
    }

    public List<String> getProtocol() {
        return protocol;
    }

    public void setProtocol(List<String> protocol) {
        this.protocol = protocol;
    }

    public List<BindHistory> getBindHistories() {
        return bindHistories;
    }

    public void setBindHistories(List<BindHistory> bindHistories) {
        this.bindHistories = bindHistories;
    }
}
