package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.browser.domain.LoginHistory;
import com.edgec.browserbackend.browser.domain.OperationHistory;
import com.edgec.browserbackend.browser.dto.HistoryListRequestDto;
import com.edgec.browserbackend.browser.dto.HistoryPageResultDto;
import com.edgec.browserbackend.browser.dto.LoginHistoryDto;
import com.edgec.browserbackend.browser.dto.OperationHistoryDto;
import org.springframework.data.domain.Page;

import java.util.List;

public interface HistoryService {

    void addLoginHistory(String username, LoginHistoryDto loginHistoryDto);

    void addOperationHistory(String username, OperationHistoryDto operationHistoryDto);

    HistoryPageResultDto getLoginHistories(String username, HistoryListRequestDto historyListRequestDto);

    HistoryPageResultDto getOperationHistories(String username, HistoryListRequestDto historyListRequestDto);

}
