package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "phoneotp")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Otp {

    /**
     * 手机号
     */
    @Id
    private String phone;

    private Integer type; //0.登陆 1.注册 2.找回密码

    /**
     * 发送给用户的短信验证码
     */
    private String otp;

    /**
     * 短信验证码的发送时间
     */
    private long createdAt;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOtp() {
        return otp;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    public long getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }
}
