package com.edgec.browserbackend.browser.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * 云平台配置表
 *
 * @Author: Chen
 * @Date: 2024年8月1日
 */
@Getter
@Setter
@NoArgsConstructor
@Document(collection = "cloudPlatformConfig")
@JsonIgnoreProperties(ignoreUnknown = true)
public class CloudPlatformConfig {

    @Id
    private String id;

    private String platform;//云平台 ali、tencent

    private String regionId;//地域id

    private String templateId;//云平台模板id

    private String usableArea;//可用区

}
