package com.edgec.browserbackend.account.service;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {

    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);

    private static final int TIME_OUT = 10 * 60; //10minues

    public enum SmsTemplateCode {
        LOGINACCOUNT(0, "SMS_472020179"),
        NEWACCOUNT(1,"SMS_472080002"),
        RESETACCOUNT(2,"SMS_471765248"),
        ;
        Integer type;
        String code;

        SmsTemplateCode(Integer type, String code) {
            this.type =type;
            this.code = code;
        }

        public Integer getType() {
            return type;
        }


        public String getCode() {
            return code;
        }

        public static SmsTemplateCode getByType(Integer type) {
            for (SmsTemplateCode smsTemplateCode : SmsTemplateCode.values()) {
                if (smsTemplateCode.type.intValue() == type.intValue()) {
                    return smsTemplateCode;
                }
            }
            return null;
        }

    }

    /**
     * Generate and send the SMS one time password to user's phone with SMS.
     *
     * @param phone
     */
    public static String sendSmsOTP(String phone, SmsTemplateCode smsTemplateCode) {
        String randomCode = createRandom(true, 6);
        DefaultProfile profile = DefaultProfile.getProfile("default", "LTAI5tEdz1DY4A4oYUawUuNH", "8KWmYgO0QIicZpyulhEwUhZqStrTwe");
        IAcsClient client = new DefaultAcsClient(profile);

        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("SignName", "无界超级浏览器");
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("TemplateCode", smsTemplateCode.getCode());
        request.putQueryParameter("TemplateParam", "{\"code\":\"" + randomCode + "\"}");
        try {
            CommonResponse response = client.getCommonResponse(request);
            if (response.getHttpStatus() == 200 && response.getData().contains("OK")) {
                return randomCode;
            } else {
                log.error("fail to send sms {} for user {}", response.getData(), phone);
                throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
            }
        } catch (ServerException e) {
            log.error("Sms sends failure", e);
            throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
        } catch (ClientException e) {
            log.error("Sms sends failure", e);
            throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
        }

    }

    public static String createRandom(boolean numberFlag, int length) {
        String retStr = "";
        String strTable = numberFlag ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int len = strTable.length();
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; i++) {
                double dblR = Math.random() * len;
                int intR = (int) Math.floor(dblR);
                char c = strTable.charAt(intR);
                if (('0' <= c) && (c <= '9')) {
                    count++;
                }
                retStr += strTable.charAt(intR);
            }
            if (count >= 2) {
                bDone = false;
            }
        } while (bDone);
        return retStr;
    }

}
