package com.edgec.browserbackend.auth.config;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.Otp;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.OtpRepository;
import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.domain.mongo.MongoOAuth2AccessToken;
import com.edgec.browserbackend.auth.repository.UserRepository;
import com.edgec.browserbackend.auth.repository.mongo.MongoOAuth2AccessTokenRepository;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

/**
 * XXXX
 *
 * @Author: Chen
 * @Date: 2024/08/22
 */
public class SMSCodeTokenGranter extends AbstractTokenGranter {

    private OtpRepository otpRepository;

    private UserRepository repository;

    public SMSCodeTokenGranter(
        AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService,
        OAuth2RequestFactory requestFactory, OtpRepository otpRepository , UserRepository repository,String grantType) {
        this( tokenServices, clientDetailsService, requestFactory, grantType);
        this.otpRepository = otpRepository;
        this.repository = repository;
    }

    protected SMSCodeTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService,
        OAuth2RequestFactory requestFactory, String grantType) {
        super(tokenServices, clientDetailsService, requestFactory, grantType);
    }


    @Override
    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map<String, String> parameters = new LinkedHashMap<String, String>(tokenRequest.getRequestParameters());
        String userName = parameters.get("username");  //客户端提交的用户名
        String smsCode = parameters.get("smscode");  //客户端提交的验证码
        User user = repository.findByUsernameAndEnabled(userName, true).orElse(null);
        if (user == null) {
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "Username does not exist: " + userName);
        }

        // 2. 校验用户输入的短信验证码是否正确
        Otp otp = otpRepository.findByPhoneAndTypeAndCreatedAtGreaterThanEqual(userName, 0, Instant.now().minusSeconds(300).toEpochMilli());
        if (otp == null) {
            throw new ClientRequestException(AccountErrorCode.OTPWRONG, AccountErrorCode.OTPWRONG.getReason());
        }
        if (!otp.getOtp().equals(smsCode)) {
            throw new ClientRequestException(AccountErrorCode.OTPWRONG, AccountErrorCode.OTPWRONG.getReason());
        }


        UsernamePasswordAuthenticationToken userAuth = new UsernamePasswordAuthenticationToken(user, null, user.getAuthorities());

        ((AbstractAuthenticationToken) userAuth).setDetails(parameters);

        OAuth2Request storedOAuth2Request = getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(storedOAuth2Request, userAuth);
    }

}
