package com.edgec.browserbackend.browser.task;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ExpireSoonWarn {

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Scheduled(cron = "0 0 9 * * ?")
    @SchedulerLock(name = "ExpireSoonWarnsendMessages", lockAtMostForString = "PT600S", lockAtLeastForString = "PT600S")
    public void sendMessages() {
        this.sendExpiredIpAccount(0);
        this.sendExpiredIpAccount(3);
        this.sendExpiredIpAccount(7);
    }

    private void sendExpiredIpAccount(int day) {
        List<IpResource> ipResources = null;
        if (day == 7) {
            ipResources = ipResourceRepository.findByValidTimeBetweenAndIsDeleted(
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day - 1).toEpochSecond() * 1000,
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day).toEpochSecond() * 1000,
                    false);
        } else {
            ipResources = ipResourceRepository.findByValidTimeBetweenAndIsDeleted(
                    Instant.now().atZone(ZoneOffset.UTC).minusDays(1).toEpochSecond() * 1000,
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day).toEpochSecond() * 1000,
                    false);
        }

        if (ipResources != null && ipResources.size() > 0) {
            Map<String, List<IpResource>> map = ipResources.stream().collect(Collectors.groupingBy(IpResource::getOwner));
            for (String key : map.keySet()) {
                if(day == 7) {
                    List<String> mouth = map.get(key).stream()
                        .filter(item -> item.getUnit().equals("mouth"))
                        .map(IpResource::getAddr).collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(mouth)){
                        sendToAccount(key, day, map.get(key).size(), mouth);
                    }
                }else if(day == 3){
                    List<String> mouth = map.get(key).stream()
                        .filter(item -> item.getUnit().equals("week"))
                        .map(IpResource::getAddr).collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(mouth)){
                        sendToAccount(key, day, map.get(key).size(), mouth);
                    }
                }else {
                    sendToAccount(key, day, map.get(key).size(),
                        map.get(key).stream().map(x -> x.getAddr()).collect(Collectors.toList()));
                }
            }
        }
    }

    private void sendToAccount(String username, int day, int amount, List<String> ips) {
        Account account = accountRepository.findByName(username).orElseThrow(() -> new ClientRequestException(AccountErrorCode.NAMENOTEXIST));
        JSONObject param = new JSONObject();
        param.put("day", day);
        param.put("amount", amount);
        if (day == 0)
            SmsUtils.sendIpSms(account.getPhoneNumber(), SmsUtils.SmsTemplateCode.IPEXPIRED, param);
        else
            SmsUtils.sendIpSms(account.getPhoneNumber(), SmsUtils.SmsTemplateCode.IPWILLEXPIRE_EXPIRE, param);
    }

}
