package com.edgec.browserbackend;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.service.ecs20140526.models.DeleteInstanceResponse;
import com.edgec.browserbackend.account.domain.UserBalance;
import com.edgec.browserbackend.account.repository.UserBalanceRepository;
import com.edgec.browserbackend.browser.domain.CloudPlatformConfig;
import com.edgec.browserbackend.browser.domain.IpHistory;
import com.edgec.browserbackend.browser.domain.ReceptionPlatformOptions;
import com.edgec.browserbackend.browser.repository.CloudPlatformConfigRepository;
import com.edgec.browserbackend.browser.repository.IpHistoryRepository;
import com.edgec.browserbackend.browser.repository.ReceptionPlatformOptionsRepository;
import com.edgec.browserbackend.browser.task.BrowserTask;
import com.edgec.browserbackend.common.client.AliEcsClient;
import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import com.edgec.browserbackend.common.utils.Aes;
import java.time.Instant;
import javax.annotation.Resource;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
class BrowserBackendApplicationTests {

    @Resource
    private ReceptionPlatformOptionsRepository repository;

    @Resource
    private BrowserTask browserTask;

    @Resource
    private CloudPlatformConfigRepository cloudPlatformConfigRepository;
    @Test
    void contextLoads() {
        ReceptionPlatformOptions receptionPlatformOptions = new ReceptionPlatformOptions();
        receptionPlatformOptions.setPlatformType(1);
        receptionPlatformOptions.setChildType(1);
        receptionPlatformOptions.setPlatform("敦煌网");
        receptionPlatformOptions.setUrl("https:www.dhgate.com");
        receptionPlatformOptions.setPictureUrl("https://ip-image.oss-rg-china-mainland.aliyuncs.com/app_image/app_image/dhgate.png");
        receptionPlatformOptions.setWeight(100);
        repository.save(receptionPlatformOptions);
    }

    @Test
    void buyEcsTest() throws Exception {
        CloudPlatformConfig config = cloudPlatformConfigRepository.findByPlatformAndRegionId("ali",
            "cn-hongkong");
        //browserTask.queryIpNewTasks();
       //AliEcsClient.runInstances("111","ceshi11","2222",config);
        //AliEcsClient.getDescribeInstances("测试","i-wz9hf0i13xj6h904k14p","cn-shenzhen");
        DeleteInstanceResponse response = AliEcsClient.deleteInstance("测试", "i-j6cd9fujd6we3dzk8z9e","cn-hongkong");
        //AliEcsClient.modifyInstanceChargeType("18711016574","Week",1,"cn-hongkong", "i-j6cd9fujd6we3dzk8z9e");
    }

    @Resource
    private IpHistoryRepository ipHistoryRepository;

    @Test
    void test3() throws Exception {
        //SmsUtils.sendSmsOTP("18711016574");
        JSONObject param = new JSONObject();
        param.put("day", "7");
        param.put("amount", "5");
        //SmsUtils.sendIpSms("18711016574", SmsUtils.SmsTemplateCode.IPWILLEXPIRE_EXPIRE, param);
    }

}
