package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.List;

@Document(collection = "userbilling")
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserBilling {

    @Id
    private String id;

    private int year;

    private int month;

    private String username;

    private Services serviceName;

    private long ownPotentialCost;//用户直接在阿里云购买的价格

    private long ownActualCost;//用户通过抢占式购买的价格

    private long ownBillingCost;//用户应该支付的服务费

    private long totalBillingCost = -1;//公司和子公司应该支付实际费用

    private BillStatus status;

    private List<DeductionRecord> deductionRecords = new ArrayList<>();

    public BillStatus getStatus() {
        return status;
    }

    public void setStatus(BillStatus status) {
        this.status = status;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public long getOwnPotentialCost() {
        return ownPotentialCost;
    }

    public void setOwnPotentialCost(long ownPotentialCost) {
        this.ownPotentialCost = ownPotentialCost;
    }

    public long getOwnActualCost() {
        return ownActualCost;
    }

    public void setOwnActualCost(long ownActualCost) {
        this.ownActualCost = ownActualCost;
    }

    public long getOwnBillingCost() {
        return ownBillingCost;
    }

    public void setOwnBillingCost(long ownBillingCost) {
        this.ownBillingCost = ownBillingCost;
    }

    public long getTotalBillingCost() {
        return totalBillingCost;
    }

    public void setTotalBillingCost(long totalBillingCost) {
        this.totalBillingCost = totalBillingCost;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Services getServiceName() {
        return serviceName;
    }

    public void setServiceName(Services serviceName) {
        this.serviceName = serviceName;
    }

    public int getMonth() {
        return month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public List<DeductionRecord> getDeductionRecords() {
        return deductionRecords;
    }

    public void setDeductionRecords(List<DeductionRecord> deductionRecords) {
        this.deductionRecords = deductionRecords;
    }

    public void addDeductionRecord(DeductionRecord record) {
        this.deductionRecords.add(record);
    }
}
