package com.edgec.browserbackend.browser.domain;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.browser.dto.ShopResultDto;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "shop")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Shop {

    @Id
    private String shopId;

    private String shopName;

    private String owner;

    private TransferStatus transferStatus;

    private String shopUrl;

    private String shopPlatform;

    private String shopAccount;

    private String shopPassword;

    private String shopUA;

    private String shopCookie;

    private long createTime;

    public Shop(){

    }

    //创建店铺使用
    public Shop of(ShopResultDto shop) {
        if (shop.getShopUrl() != null)
            this.setShopUrl(shop.getShopUrl());
        if (shop.getOwner() != null)
            this.setOwner(shop.getOwner());
        if (shop.getShopPlatform() != null)
            this.setShopPlatform(shop.getShopPlatform());
        if (shop.getShopName() != null)
            this.setShopName(shop.getShopName());
        if (shop.getTransferStatus() != null)
            this.setTransferStatus(shop.getTransferStatus());
        if (shop.getShopAccount() != null)
            this.setShopAccount(shop.getShopAccount());
        if (shop.getShopPassword() != null)
            this.setShopPassword(shop.getShopPassword());
        if (shop.getShopUA() != null)
            this.setShopUA(shop.getShopUA());
        if (shop.getShopCookie() != null)
            this.setShopCookie(shop.getShopCookie());
        if (shop.getCreateTime() != 0)
            this.setCreateTime(shop.getCreateTime());
        return this;
    }

    public Shop of(Shop shop) {
        if (shop.getShopUrl() != null)
            this.setShopUrl(shop.getShopUrl());
        if (shop.getOwner() != null)
            this.setOwner(shop.getOwner());
        if (shop.getShopPlatform() != null)
            this.setShopPlatform(shop.getShopPlatform());
        if (shop.getShopName() != null)
            this.setShopName(shop.getShopName());
        if (shop.getTransferStatus() != null)
            this.setTransferStatus(shop.getTransferStatus());
        if (shop.getShopAccount() != null)
            this.setShopAccount(shop.getShopAccount());
        if (shop.getShopPassword() != null)
            this.setShopPassword(shop.getShopPassword());
        if (shop.getShopUA() != null)
            this.setShopUA(shop.getShopUA());
        if (shop.getShopCookie() != null)
            this.setShopCookie(shop.getShopCookie());
        if (shop.getCreateTime() != 0)
            this.setCreateTime(shop.getCreateTime());
        return this;
    }

    public String getShopId() {
        return shopId;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public String getOwner() {
        return owner;
    }

    public String getShopPlatform() {
        return shopPlatform;
    }

    public String getShopName() {
        return shopName;
    }

    public TransferStatus getTransferStatus() {
        return transferStatus;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setShopPlatform(String shopPlatform) {
        this.shopPlatform = shopPlatform;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public void setTransferStatus(TransferStatus transferStatus) {
        this.transferStatus = transferStatus;
    }

    public String getShopAccount() {
        return shopAccount;
    }

    public void setShopAccount(String shopAccount) {
        this.shopAccount = shopAccount;
    }

    public String getShopPassword() {
        return shopPassword;
    }

    public void setShopPassword(String shopPassword) {
        this.shopPassword = shopPassword;
    }

    public String getShopCookie() {
        return shopCookie;
    }

    public void setShopCookie(String shopCookie) {
        this.shopCookie = shopCookie;
    }

    public String getShopUA() {
        return shopUA;
    }

    public void setShopUA(String shopUA) {
        this.shopUA = shopUA;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

}
