package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.List;

@Document(collection = "userprepaidbilling")
@JsonIgnoreProperties(ignoreUnknown = true)
@CompoundIndex(name = "idx_username_timestamp", def = "{'username': 1, 'timestamp': 1}")
public class UserPrePaidBilling {

    @Id
    private String id;

    private String username;

    private int year;

    private int month;

    private long timestamp;

    private Services services = Services.ECC;

    private float rate;

    private int amount;

    private int period;

    private BillStatus status;

    //0 -- 余额, 2 -- 支付宝, 3 -- 微信
    private int payMethod;

    private boolean isPrepaid;

    private String user;

    private float ownPotentialCost = 0;

    private float ownActualCost = 0;

    private float ownBillingCost = 0;

    private float total;
    //0 -- 充值, 1 -- newip, 2 --renew, 3 --ipkeptfee, 4 --deleteip,
    private int chargeType;

    private String target;

    private String unit = "month";

    private List<DeductionRecord> deductionRecords = new ArrayList<>();

    public float getRate() {
        return rate;
    }

    public float getTotal() {
        return total;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setTotal(float total) {
        this.total = total;
    }

    public int getChargeType() {
        return chargeType;
    }

    public void setChargeType(int chargeType) {
        this.chargeType = chargeType;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Services getServices() {
        return services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public float getOwnPotentialCost() {
        return ownPotentialCost;
    }

    public void setOwnPotentialCost(float ownPotentialCost) {
        this.ownPotentialCost = ownPotentialCost;
    }

    public float getOwnActualCost() {
        return ownActualCost;
    }

    public void setOwnActualCost(float ownActualCost) {
        this.ownActualCost = ownActualCost;
    }

    public BillStatus getStatus() {
        return status;
    }

    public void setStatus(BillStatus status) {
        this.status = status;
    }

    public boolean isPrepaid() {
        return isPrepaid;
    }

    public void setPrepaid(boolean prepaid) {
        this.isPrepaid = prepaid;
    }

    public List<DeductionRecord> getDeductionRecords() {
        return deductionRecords;
    }

    public void setDeductionRecords(List<DeductionRecord> deductionRecords) {
        this.deductionRecords = deductionRecords;
    }

    public void addDeductionRecord(DeductionRecord record) {
        this.deductionRecords.add(record);
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getPeriod() {
        return period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public float getOwnBillingCost() {
        return ownBillingCost;
    }

    public void setOwnBillingCost(float ownBillingCost) {
        this.ownBillingCost = ownBillingCost;
    }

    public String getUser() {
        if(StringUtils.isEmpty(user))
            return username;
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(int payMethod) {
        this.payMethod = payMethod;
    }
}
