package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.UserBalance;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class UserBalanceRepositoryCustomImpl implements UserBalanceRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public void incrementBalance(UserBalance balance, float deltaBbalanced, float deltaUsed) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("username").is(balance.getUsername()));
        Update update = new Update();
        update.inc("balanced", deltaBbalanced).inc("used", deltaUsed);
        mongoTemplate.updateFirst(basicQuery, update, UserBalance.class);

    }
}
