package com.edgec.browserbackend.auth.service.security;

import com.edgec.browserbackend.auth.domain.Roles;
import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.repository.RolesRepository;
import com.edgec.browserbackend.auth.repository.UserRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;


import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class MongoUserDetailsService implements UserDetailsService {

    @Autowired
    private UserRepository repository;

    @Autowired
    private RolesRepository rolesRepository;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {

        User user = repository.findById(username).orElse(null);

        if (user == null && !StringUtils.isEmpty(username) && username.contains("@")) {
            user = repository.findByEmail(username).orElse(null);
        }

        if (user == null && !StringUtils.isEmpty(username) && StringUtils.isNumeric(username)) {
            user = repository.findByPhone(username).orElse(null);
        }

        if (user == null)
            throw new UsernameNotFoundException(username);

        Optional<Roles> roles = rolesRepository.findById(username);

        if (roles.isPresent() && !StringUtils.isEmpty(roles.get().getRoles())) {

            String[] userRoles = roles.get().getRoles().split(",");

            List<GrantedAuthority> authorities = new ArrayList<>();
            for (String userRole : userRoles) {
                SimpleGrantedAuthority role = new SimpleGrantedAuthority("ROLE_" + userRole);
                authorities.add(role);
            }
            user.setAuthorities(authorities);
        }

        return user;
    }
}
